/*
 * Decompiled with CFR 0.152.
 */
package entities.missiles.sona;

import core.Sprite;
import core.states.GameState;
import entities.Entity;
import entities.creatures.CreatureEntity;
import entities.creatures.EnemyCreatureEntity;
import entities.creatures.player.SonaEntity;
import entities.missiles.MissileEntity;
import java.util.ArrayList;
import util.Config;
import util.ResourceManager;

public final class SonaShotEntity
extends MissileEntity {
    private Sprite[] frames = new Sprite[2];
    private long lastFrameChange;
    private long frameDuration = 200L;
    private int frameNumber;
    private boolean used = false;
    private boolean powerChord = false;
    private char powerChordType;

    public SonaShotEntity(SonaEntity parent, GameState game, int x, int y) {
        super(parent, game, "missiles/sona/shot", x, y);
        this.frames[0] = this.sprite;
        this.frames[1] = ResourceManager.get().getSprite("missiles/sona/shot2");
        this.dy = this.moveSpeed = (double)(-Math.min(Config.get(Config.sonaShotProjectileSpeed) + Config.get(Config.sonaShotProjectileSpeedPerLevel) * game.getLevel(), Config.get(Config.sonaShotProjectileSpeedCap)));
    }

    public boolean isPowerChord() {
        return this.powerChord;
    }

    public char getPowerChordType() {
        return this.powerChordType;
    }

    public void setPowerChord(char powerChordType) {
        this.powerChord = true;
        this.powerChordType = powerChordType;
        this.frames[0] = this.sprite = ResourceManager.get().getSprite("missiles/sona/powerchord" + powerChordType);
        this.frames[1] = ResourceManager.get().getSprite("missiles/sona/powerchord" + powerChordType + "2");
    }

    @Override
    public void move(long delta) {
        super.move(delta);
        this.lastFrameChange += delta;
        if (this.lastFrameChange > this.frameDuration) {
            this.lastFrameChange = 0L;
            ++this.frameNumber;
            if (this.frameNumber >= this.frames.length) {
                this.frameNumber = 0;
            }
            this.sprite = this.frames[this.frameNumber];
        }
    }

    @Override
    public void collidedWith(Entity other) {
        if (this.used) {
            return;
        }
        if (other instanceof EnemyCreatureEntity) {
            this.game.removeEntity(this);
            ((CreatureEntity)other).damage(this, Config.get(Config.sonaShotDamage));
            if (this.powerChord) {
                switch (this.powerChordType) {
                    case 'Q': {
                        ((CreatureEntity)other).damage(this, Config.get(Config.sonaPowerChordQDamage));
                        break;
                    }
                    case 'W': {
                        this.parent.addEffect("bufferDiminuendo", this.game.getTime() + (long)Config.get(Config.sonaPowerChordWDuration));
                        break;
                    }
                    case 'E': {
                        long time = this.game.getTime();
                        ArrayList<Entity> entities = this.game.getEntities();
                        int i = 0;
                        while (i < entities.size()) {
                            Entity entity = entities.get(i);
                            if (entity instanceof EnemyCreatureEntity) {
                                ((CreatureEntity)entity).addMoveSpeedMultiplier(Config.get(Config.sonaPowerChordEMultiplier), time + (long)Config.get(Config.sonaPowerChordEDuration));
                            }
                            ++i;
                        }
                        ((SonaEntity)this.parent).setLastPowerChordETime(time);
                    }
                }
                ResourceManager.get().playSound("sona_powerchord_hit");
            } else {
                ResourceManager.get().playSound("sona_shot_hit");
            }
            this.used = true;
        }
    }
}

